Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Modern/Perl.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-SVG-TT-Graph
Version:        1.04
Release:        alt2_17
Summary:        Base object for generating SVG Graphs
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl

URL:            https://metacpan.org/release/SVG-TT-Graph
Source0:        https://cpan.metacpan.org/authors/id/L/LL/LLAP/SVG-TT-Graph-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Run-time
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(DateTime.pm)
BuildRequires:  perl(HTTP/Date.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Template.pm)
BuildRequires:  perl(vars.pm)
# Tests
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/More.pm)


Source44: import.info

%description
This package can be used as a base for creating SVG graphs with
Template Toolkit.

%prep
%setup -q -n SVG-TT-Graph-%{version}
# Remove bundled libraries
find . -type f -exec chmod 644 {} \;
sed -i '1s,#!.*perl,#!/usr/bin/perl,' script/timeseries.pl
# chmod +x script/*.pl

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build} %{?_smp_mflags}

%install
%{makeinstall_std} DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
%{make_build} test

%files
%doc Changes README script
%doc --no-dereference LICENSE
%{perl_vendor_privlib}/SVG*

%changelog
