# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/All.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Moose.pm) perl(Path/Class.pm) perl(Path/Tiny.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Scalar-Does
%define upstream_version 0.203

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    Additional constants for Scalar::Does, inspired by the built-in Moose type constraints
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Scalar/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Exporter/Tiny.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/NoWarnings.pm)
BuildRequires: perl(Test/Requires.pm)
BuildRequires: perl(Type/Tiny.pm)
BuildRequires: perl(URI.pm)
BuildRequires: perl(URI/file.pm)
BuildRequires: perl(lexical/underscore.pm)
BuildRequires: perl(namespace/clean.pm)
BuildArch:  noarch

Obsoletes:  perl-IO-Detect < 0.5.0-4
Source44: import.info

%description
It has long been noted that Perl would benefit from a 'does()' built-in. A
check that 'ref($thing) eq 'ARRAY'' doesn't allow you to accept an object
that uses overloading to provide an array-like interface.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc COPYRIGHT CREDITS Changes INSTALL LICENSE META.json META.yml  NEWS README SIGNATURE TODO
%{perl_vendor_privlib}/*


%changelog
