# BEGIN SourceDeps(oneline):
BuildRequires: perl(CGI.pm) perl(Compress/Zlib.pm) perl(Encode.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(IO/File.pm) perl(Test.pm)
# END SourceDeps(oneline)
%define module_version 3.0
%define module_name Sdict
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.0
Release: alt1
Summary: Module to work with Sdictionary .dct files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SW/SWAJ/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
use Sdict;


    # File compilation/decompilation
_$Sdict::debug = 1;

_$sd = Sdict->new;

_$sd->parse_args;

_$sd->analyze;

_$sd->convert;

_exit;


    # Working with .dct
_$sd = Sdict->new;

_$sd->debug_on; # or $sd->debug_off;

_$sd->init ( { file => 'test.dct' } );

    # Load dictionary
_unless ($sd->load_dictionary_fast) {
_    die 'Unable load dictionary';
_}


    # Locate word
        my $article = $sd->search_word ('fox');
        print "translation is '$article'\n" if $article;


    # Unload dictionary
_$sd->unload_dictionary;


    # If you are interested about header only
        unless ($sd->read_header) {
            die 'Unable to load dictionary';
            next;
        }

        warn "found '$sd->{header}->{title}'";


    # Information about dictionary
        $title = $sd->{header}->{title};
_$copyright = $sd->{header}->{copyright};
_$word_lang = $sd->{header}->{w_lang};
_$article_lang = $sd->{header}->{a_lang};
_$version = $sd->{header}->{version};
_$words_total = $sd->{header}->{words_total};


    # Print info
_$sd->print_dct_info;



    # Get words from current position
_for (my $i=0; $i < SDICT_LOAD_ITEMS; $i++) {

        _$word = $sd->get_next_word;
__$word = decode ("utf8", $word);

_        last if ($curWord eq q{}); # Last word reached

__warn "word '$word'";

__...
_}

_$pos = $sd->{f_index_pos_cur};


    # Get previous word
_$word = $sd->get_prev_word;


    # Get article you stay on
_$article = $sd->read_unit($sd->{cur_word_pos} + $sd->{articles_pos});

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_privlib/latin-cyrillic.pl

%files
%doc Changes README
%perl_vendor_privlib/S*

%files scripts
%_bindir/*

%changelog
