# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(CPAN.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(Cwd.pm) perl(Data/UUID.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(File/Map.pm) perl(File/Path.pm) perl(IO/All.pm) perl(IO/File.pm) perl(JSON.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Markdown.pm) perl(Readonly.pm) perl(Test/More.pm) perl(Test/XT.pm) perl(Time/HiRes.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_name Set-SegmentTree
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Immutable segment trees with flatbuffers in perl
Group: Development/Perl
License: perl_5
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAVIDIAM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
wat? Segment Tree

A Segment tree is an immutable tree structure used to efficiently
resolve a value to the set of segments which encompass it.

Why?

You have a large set of value intervals (like time segments!) and
need to match them against a single value (like a time) efficiently.

This solution is suitable for problems where the set of intervals is
known in advance of the queries, and the tree needs to be loaded and
queried efficiently many orders of magnitude more often than the set
of intervals is updated.

Data structure:

A segment is like this:
 [ Segment Label, Start Value , End Value ]

Start Value and End Values Must be numeric.

Start Value Must be less than End Value

Segment Identity Must occur exactly once

The speed of Set::SegmentTree depends on not being concerned
with additional segment relevant data, so it is expected one would
use the identity to refer into whatever persistence retains
additional information about the segment.

Use walkthrough

 my @segments = (['A',1,5],['B',2,3],['C',3,8],['D',10,15]);

This defines four intervals which both do and don't overlap 
 - A - 1 to 5
 - B - 2 to 3
 - C - 3 to 8
 - D - 10 to 15

Doing a find within the resulting tree 

 my $tree = Set::SegmentTree::Builder->new(@segments)->build

Would make these tests pass

 is_deeply [$tree->find(0)], [];
 is_deeply [$tree->find(1)], [qw/A/];
 is_deeply [$tree->find(2)], [qw/A B/];
 is_deeply [$tree->find(3)], [qw/A B C/];
 is_deeply [$tree->find(4)], [qw/A C/];
 is_deeply [$tree->find(6)], [qw/C/];
 is_deeply [$tree->find(9)], [];
 is_deeply [$tree->find(12)], [qw/D/];

And although this structure is relatively expensive to build,
it can be saved efficiently,

 my $builder = Set::SegmentTree::Builder->new(@segments);
 $builder->to_file('filename');

and then loaded and queried extremely quickly, making this 
pass in only milliseconds.

 my $tree = Set::SegmentTree->from_file('filename');
 is_deeply [$tree->find(3)], [qw/A B C/];

This structure is useful in the use case where...

1) value segment inter...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md README
%perl_vendor_privlib/S*

%changelog
