# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_name Set-Select
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: select common subsets from two or more sets
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PJ/PJUHASZ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is an OO module that makes it possible to select common subsets (e.g.
unions, intersection, or any other combination) from two or more input sets
efficiently with a terse query syntax.

The input sets must be fed to the constructor as array references.
It is a fatal error if any of the arguments is not an array reference.

The returned object has a method called select, which accepts a selector
string argument and emits (an arrayref of) the elements that match the selector.
The selector strings consist of literal `1's and `0's, and they should be
as long as the number of input sets. For example, if we have 3 input sets,
then the '110' selector string selects all elements that are in the first
and second sets but not in the third.

However, it is important to note that the selector string is matched as a
regular expression, as shown in the synopsis. E.g. unions can be best
expressed with the `.' metacharacter, but it is possible to use all arbitrarily
clever regex features. The selector string is passed into a regular
expression which is anchored at both ends (i.e. `/^$expression$/').

A Venn diagram (matching the example above) that may or may not make the intent clearer:


       Elements:                 Selectors:
         .---.                     .---.
        /  1  \                   / 100 \
       |       |                 |       |
    .--+--. .--+--.           .--+--. .--+--.
   /   | 3 X 5 |   \         /   |110X101|   \
  |    |  / \  |    |       |    |  / \  |    |
  |  2  \/ 7 \/  4  |       | 010 \/111\/ 001 |
  |     |`---'|     |       |     |`---'|     |
  |      \ 6 /      |       |      \011/      |
   \      \ /      /         \      \ /      /
    `------^------'           `------^------'

Every distinct region of the Venn-diagram is addressable with a unique
selector string.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/S*

%changelog
