%define module_version 0.003
%define module_name Sort-Key-Top-PP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Callback.pm) perl(Sort/Key/Top.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: pure Perl implementation of parts of Sort::Key::Top
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Sort-Key-Top-PP

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Sort::Key::Top::PP is set of functions for finding the top "n" items in an
array by some criteria. It's not as fast as the Sort::Key::Top manpage, but it is
generally quite a bit faster than sorting the entire array and taking the
first "n" items.

This module implements pure Perl equivalents of the following functions as
descibed in the Sort::Key::Top manpage.

=over

=item *

`top'

=item *

`topsort'

=item *

`keytop'

=item *

`keytopsort'

=item *

`ntop'

=item *

`ntopsort'

=item *

`nkeytop'

=item *

`nkeytopsort'

=item *

`rtop'

=item *

`rtopsort'

=item *

`rkeytop'

=item *

`rkeytopsort'

=item *

`rntop'

=item *

`rntopsort'

=item *

`rnkeytop'

=item *

`rnkeytopsort'

=item *

`head'

=item *

`nhead'

=item *

`keyhead'

=item *

`nkeyhead'

=item *

`tail'

=item *

`ntail'

=item *

`keytail'

=item *

`nkeytail'

=back

By default *all functions are exported*. If you don't like that, then
please specify an explicit list of functions to import, a la:

  use Sort::Key::Top::PP 'top';


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYRIGHT README Changes LICENSE examples
%perl_vendor_privlib/S*

%changelog
