# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Template.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.012
%define module_name Stlgen
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.012
Release: alt5
Summary: Create "Standard Template Library" (STL) C++ type containers but generate code in other languages.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GS/GSLONDON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Stlgen is based off the Standard Template Library (STL) for C++ here:

_http://www.cplusplus.com/reference/stl/

The difference is that Stlgen will generate instances of STL templates
in a different language. The default language is c.

This example below uses Stlgen to generate list_uint.(c/h) files which will implement
a linked list container coded in the c language.

_#!/usr/bin/perl -w

_use Stlgen;

_my $inst = Stlgen->New(
__Template=>'list', 
__Instancename => 'uint',
__payload => [
___{name=>'uint',   type=>'unsigned int', dumper=>'printf("\t\tuint = %%u\n", currelement->uint);'},
__],
_);

_$inst->Instantiate();

You could use these files in a main.c program like this:

_#include <stdio.h>
_#include "list_uint.h"

_int main (void) {

__struct list_uint_list *mylist;

__mylist = list_uint_constructor();
_
__list_uint_push_back(mylist, 21);
__list_uint_push_back(mylist, 99);
__list_uint_push_back(mylist, 33);
__list_uint_push_back(mylist, 34);
__list_uint_push_back(mylist, 67);
__list_uint_push_back(mylist, 12);
__list_uint_push_back(mylist, 28);
__list_uint_push_back(mylist, 55);
__list_uint_push_back(mylist, 76);

__list_uint_sort(mylist);

__printf("\n\n\nThis is the sorted list\n");
__list_uint_list_dumper(mylist);

__return 0;
_}

The above c program currently works and produces the following output
when you compile and execute it:

_This is the sorted list
_// list at address 140644360{
_'beforefirst' marker:
__// element at address 8621018
___prev = 0
___next = 8621088
___uint = 0
_user elements:
__// element at address 8621088
___prev = 8621018
___next = 8621038
___uint = 12
__// element at address 8621038
___prev = 8621088
___next = 8621098
___uint = 21
__// element at address 8621098
___prev = 8621038
___next = 8621058
___uint = 28
__// element at address 8621058
___prev = 8621098
___next = 8621068
___uint = 33
__// element at address 8621068
___prev = 8621058
___next = 86210a8
___uint = 34
__// element at address 86210a8
___prev = 8621068
___next = 8621078
___uint = 55
__// element at address 8621078
___prev = 86210a8
___next = 86210b8
___uint = 67
__// element at address 86210b8
___prev = 8621078
___next = 8621048
___uint = 76
__// element at address 8621048
___prev = 86210b8
___next = 8621028
___uint = 99
_'afterlast' marker:
__// element at address 8621028
___prev = 8621048
___next = 0
___uint = 0


Note: this is a pre-alpha version. Currently the only STL container 
implemented is the linked list. And that hasn't been tested very well yet.
The "push", "pop", "size", "sort", and "dumper" functions are known to work.




%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
