%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.18
%define module_name String-CaseProfile
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt1
Summary: Get/Set the letter case profile of a string
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/EN/ENELL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module provides a convenient way of handling the recasing (letter case
conversion) of sentences/phrases/chunks in machine translation, case-sensitive
search and replace, and other text processing applications.

String::CaseProfile includes three functions:

get_profile determines the letter case profile of a string.

set_profile applies a letter case profile to a string; you can apply a
profile determined by get_profile, or you can create your own custom profile.

copy_profile gets the profile of a string and applies it to another string
in a single step.

These functions are Unicode-aware and support text in languages based on alphabets
which feature lowercase and uppercase letter forms (Roman, Greek, Cyrillic and
Armenian).
You must feed them utf8-encoded strings.

get_profile and set_profile use the following identifiers to classify
word and string types according to their case:

=over 4

=item * `all_lc'

In word context, it means that all the letters are lowercase.
In string context, it means that every word is of `all_lc' type.

=item * `all_uc'

In word context, it means that all the letters are uppercase.
In string context, it means that every word is of `all_uc' type.

=item * `1st_uc'

In word context, it means that the first letter is uppercase,
and the other letters are lowercase.
In string context, it means that the type of the first word is `1st_uc',
and the type of the other words is `all_lc'.

=item * `other'

Undefined type (e.g. a CamelCase code identifier in word context, or a
string containing several alternate types in string context.)

=back



%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/S*

%changelog
