%define module_name Sys-Export
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(Data/Printer.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Map.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(File/stat.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/Util.pm) perl(Module/Runtime.pm) perl(POSIX.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(Storable.pm) perl(Symbol.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Suite.pm) perl(Test2/Tools/Subtest.pm) perl(Test2/V0.pm) perl(Unix/Mknod.pm) perl(User/pwent.pm) perl(autodie.pm) perl(experimental.pm) perl(integer.pm) perl(lib.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.003
Release: alt1
Summary: Export a subset of installed system files, for initrd or containers
Group: Development/Perl
License: perl
URL: https://github.com/nrdvana/perl-Sys-Export

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is designed to export a subset of an operating system to a new directory,
automatically detecting and including any libraries or interpreters required by the requested
subset, and optionally rewriting paths and users/groups and updating the copied files to refer
to the rewritten paths, when possible.

The actual export implementation is handled by a OS-specific module, like the Sys::Export::Linux manpage.
This top-level module just exports methods.  You can configure a global exporter instance on
the `use' line, and then call its methods via exported functions.  For instance,

  use Sys::Export \%%options;

is roughly equivalent to:

  BEGIN {
    if ($^O eq 'linux') {
      require Sys::Export::Linux;
      $Sys::Export::exporter= Sys::Export::Linux->new(\%%options);
    } else {
      ...
    }
    sub exporter      { $Sys::Export::exporter }
    sub add           { $Sys::Export::exporter->add(@_) }
    sub rewrite_path  { $Sys::Export::exporter->rewrite_path(@_) }
    sub rewrite_user  { $Sys::Export::exporter->rewrite_user(@_) }
    sub rewrite_group { $Sys::Export::exporter->rewrite_group(@_) }
    sub finish        { $Sys::Export::exporter->finish }
  }

In other words, just a convenience for creating an exporter instance and giving you access to
most of its important methods without needing to reference the object.  You can skip this
module entirely and just directly use a `Sys::Export::Linux' object, if you prefer.

Currently, only Linux is fully supported.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/S*

%changelog
