%add_findreq_skiplist %perl_vendor_archlib/Table/*.pl
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Benchmark.pm) perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Storable.pm) perl(blib.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name Table-ParentChild
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt7
Summary: Fast lookup for Parent-Child relationships
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MI/MIKEWONG/%module_name-%module_version.tar.gz

%description
Table::ParentChild implements a cross-linked list in two
dimensions. It is ideal for describing the parent-child 
relationships of large numbers of entities. For maximum
speed, Table::ParentChild uses hashes to get access to
the table row/column headers, and then traverses a linked-
list written in XS. The emphasis of development was on
speed first, small memory footprint second, ease-of-use 
third, and flexibility be damned :^)>.

To populate a table, simply build an array of arrays.
The first element in the sub-array is the id of the parent.
The second element of the sub-array is the id of the child.
The third (and optional) element of the sub-array is the
quantity. Table::ParentChild will automatically build
appropriate headers for the table and populate the table,
returning a table object for your lookup pleasure.

Be forewarned that ids are implemented as unsigned long 
integers and quantities are implemented as floating point 
values. The values you feed the table will be coerced into 
the appropriate data type, which may cause a failure in 
translation of the data.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/T*
%perl_vendor_autolib/*

%changelog
