Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(File/Find/Object.pm) perl(IO/All.pm) perl(Path/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 14

Name:           perl-Term-Shell
Version:        0.13
Release:        alt1_%autorelease
Summary:        Simple command-line shell framework
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Term-Shell
Source0:        https://cpan.metacpan.org/modules/by-module/Term/Term-Shell-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Module Run-time:
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(IO/Select.pm)
BuildRequires:  perl(Term/ReadLine.pm)
# Optional, but upstream's metadata says required Run-Time:
BuildRequires:  perl(Term/ReadKey.pm)
BuildRequires:  perl(Text/Autoformat.pm)
# Optional Run-time:
#BuildRequires: perl(Term::InKey)  not yet packaged in Fedora
#BuildRequires: perl(Term::Screen) not yet packaged in Fedora
BuildRequires:  perl(Term/Size.pm)
# Test:
BuildRequires:  perl(base.pm)
BuildRequires:  perl(blib.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IPC/Open3.pm)
BuildRequires:  perl(Test/More.pm)
# Dependencies:
Requires:       perl(File/Temp.pm)
Requires:       perl(Term/ReadKey.pm)
Requires:       perl(Text/Autoformat.pm)
Requires:       perl(Term/InKey.pm)
Requires:       perl(Term/Screen.pm)
Requires:       perl(Term/Size.pm)

# tests sub-package dropped during development phase for Fedora 32
Obsoletes:     perl-Term-Shell-tests < %{version}-%{release}
Provides:      perl-Term-Shell-tests = %{version}-%{release}
Source44: import.info

%description
Term::Shell lets you write simple command-line shells. All the boring
details like command-line parsing, terminal handling, and tab completion
are handled for you.

%prep
%setup -q -n Term-Shell-%{version}

%build
perl Build.PL --installdirs=vendor
./Build

%install
./Build install --destdir=%{buildroot} --create_packlist=0
# %{_fixperms} -c %{buildroot}

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes examples/ README t/
%{perl_vendor_privlib}/Term/

%changelog
