%define module_name Test-Collectd-Plugins
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Collectd.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/ShareDir.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(FindBin.pm) perl(IO/File.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Find.pm) perl(Net/FTP.pm) perl(Package/Alias.pm) perl(Parse/CPAN/Meta.pm) perl(Parse/Lex.pm) perl(Parse/Yapp/Driver.pm) perl(Socket.pm) perl(Test/Builder.pm) perl(Test/File/ShareDir.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1009
Release: alt1
Summary: Common out-of-band collectd plugin test suite
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FA/FAXMODEM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Test::More;
  use Test::Collectd::Plugins typesdb => ["/usr/share/collectd/types.db"];

  plan tests => 4;

  load_ok ("Collectd::Plugins::Some::Plugin");
  read_ok ("Collectd::Plugins::Some::Plugin", "plugin_name_as_returned_by_dispatch");
  read_config_ok ("My::Plugin", "my_plugin", "/path/to/my_plugin.conf");

  my $expected = [[{{ plugin => "my_plugin", type => "gauge", values => [ 42 ] }}]];
  my $got = read_values_config ("My::Plugin", "my_plugin", "/path/to/my_plugin.conf");

  is_deeply ($got, $expected);

  done_testing;

Testing collectd modules outside of collectd's perl interpreter is tedious, as you cannot
simply 'use' them. In fact you can't even 'use Collectd', try it and come back.
This module lets you test collectd plugins outside of the collectd daemon. It is supposed
to be the first step in testing plugins, detecting syntax errors and common mistakes. 
There are some caveats (see dedicated section), and you should use the usual collectd testing
steps afterwards e.g. enabling debug at compile time, then running the collectd binary in
the foreground while using some logging plugin, plus some write plugin. I usually use logfile
to STDOUT and csv plugin.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt Changes
%perl_vendor_privlib/F*
%perl_vendor_privlib/T*
%perl_vendor_privlib/auto/*
%changelog
