%define module_name Test-DBChanges
# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBI.pm) perl(DBIx/Class/Core.pm) perl(DBIx/Class/Schema.pm) perl(DBIx/Class/Schema/Loader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(Moo.pm) perl(Moo/Role.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/PostgreSQL.pm) perl(Test/Spelling.pm) perl(Types/Standard.pm) perl(base.pm) perl(lib.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.2
Release: alt1
Summary: track changes to database tables
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAKKAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Sometimes, when testing code that makes changes to a database, it's
useful to see which rows where inserted / updated / deleted. This
distribution provides mechanisms to do just that.

This distribution provides these classes:

=over

=item the section on "`Test::DBChanges::Pg'"

to track changes in a PostgreSQL database

=item the section on "`Test::DBChanges::Pg::DBIC'"

to track changes in a the section on "`DBIx::Class::Schema'" connected to a
PostgreSQL database

=back

They install a set of triggers in the database, that record all
changes (insert, update, delete) to a set of tables.

They can then parse this record into a
changeset, which will build hashrefs (or
objects) corresponding to each changed row.

This should really only be used in tests. At the moment the tables,
stored procedures and triggers that these classes need are installed
but never removed.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/T*

%changelog
