%define module_version 0.002
%define module_name Test-Deep-NumberTolerant
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Number/Tolerant.pm) perl(Test/Deep.pm) perl(Test/Deep/Cmp.pm) perl(Test/More.pm) perl(Test/Tester.pm) perl(if.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: A Test::Deep plugin for testing numbers within a tolerance range
Group: Development/Perl
License: perl
URL: https://github.com/karenetheridge/Test-Deep-NumberTolerant

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETHER/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
`Test::Deep::NumberTolerant' provides the sub `within_tolerance' to indicate
that the data being tested matches the equivalent `tolerance(...)' value.

I wrote this because I found myself doing this a lot:

    cmp_deeply(
        $thing,
        methods(
            delete_time => methods(epoch => code( sub { $_[0] == tolerance(time(), plus_or_minus => 2) || (0, "got $_[0], expected ", time()) } )),
        ),
        'object has been deleted',
    );

With this module, this can be simplified to the much more readable:

    cmp_deeply(
        $thing,
        methods(
            delete_time => methods(epoch => within_tolerance(time(), plus_or_minus => 2)),
        ),
        'object has been deleted',
    );


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
