# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(File/Temp.pm) perl(HTTP/Message.pm) perl(HTTP/Tiny.pm) perl(JSON/Tiny.pm) perl(MIME/Types.pm) perl(Method/Signatures.pm) perl(Moose.pm) perl(MooseX/Types.pm) perl(MooseX/Types/HTTPMethod.pm) perl(MooseX/Types/Moose.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/Mocha.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Types/Standard.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define module_version 0.001
%define module_name Test-Mountebank
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Perl client library for mountebank
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAGFINNR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The example in the synopsis builds an object structure that generates JSON code like
the following, which can be sent to the running mountebank instance in a POST request.

    {
        "port": 4546,
        "protocol": "http",
        "stubs": [
            {
                "predicates": [
                    {
                        "equals": {
                            "method": "GET",
                            "path": "/foobar.json"
                        }
                    }
                ],
                "responses": [
                    {
                        "is": {
                            "body": {
                                "foo": "bar"
                            },
                            "headers": {
                                "Content-Type": "application/json"
                            },
                            "statusCode": 200
                        }
                    }
                ]
            },
            {
                "predicates": [
                    {
                        "equals": {
                            "method": "GET",
                            "path": "/qux/999/json"
                        }
                    }
                ],
                "responses": [
                    {
                        "is": {
                            "body": "{ \"error\": \"No such qux: 999\" }",
                            "headers": {
                                "Content-Type": "application/json"
                            },
                            "statusCode": 404
                        }
                    }
                ]
            },
            {
                "predicates": [
                    {
                        "equals": {
                            "method": "GET",
                            "path": "/foobar.html"
                        }
                    }
                ],
                "responses": [
                    {
                        "is": {
              ...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE
%perl_vendor_privlib/T*

%changelog
