%define module_name Test-Nginx
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Digest/SHA.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Find.pm) perl(File/Path.pm) perl(File/Temp.pm) perl(Filter/Util/Call.pm) perl(HTTP/Response.pm) perl(IO/Select.pm) perl(IO/Socket.pm) perl(IO/Socket/INET.pm) perl(IPC/Run.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(POSIX.pm) perl(Parse/CPAN/Meta.pm) perl(Test/Base.pm) perl(Test/Deep.pm) perl(Test/LongString.pm) perl(Text/Diff.pm) perl(Time/HiRes.pm) perl(URI/Escape.pm) perl(YAML.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.30
Release: alt1
Summary: Testing modules for Nginx C module development
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AG/AGENT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution provides two testing modules for Nginx C module development:.
=over

=item *

the Test::Nginx::Socket manpage (This is recommended.)

=item *

the Test::Nginx::LWP manpage (This is obsolete.)

=back

All of them are based on the Test::Base manpage.

Usually, the Test::Nginx::Socket manpage is preferred because it works on a much lower
level and not that fault tolerant like the Test::Nginx::LWP manpage.

Also, a lot of connection hang issues (like wrong `r->main->count' value in nginx
0.8.x) can only be captured by the Test::Nginx::Socket manpage because Perl's the LWP::UserAgent manpage client
will close the connection itself which will conceal such issues from
the testers.

Test::Nginx automatically starts an nginx instance (from the `PATH' env)
rooted at t/servroot/ and the default config template makes this nginx
instance listen on the port `1984' by default. One can specify a different
port number by setting his port number to the `TEST_NGINX_PORT' environment,
as in

    export TEST_NGINX_PORT=1989


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes
%perl_vendor_privlib/T*

%changelog
