# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Coverage.pm) perl(Socket.pm) perl(Test/Builder/Tester.pm) perl(Test/More.pm) perl(YAML/Syck.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name Test-Pod-Coverage-Permissive
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: Checks for pod coverage regression.
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GU/GUGU/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Checks for POD coverage regressions in your code. This module is for large projects, which can't be covered by POD for a
5 minutes. If you have small module or your project is fully covered - use the Test::Pod::Coverage manpage instead.

After first run, this module creates data file, where saves all uncovered subroutines. If you create new uncovered
subroutine, it will fail. If you create new package with uncovered subroutines, it will fail. Otherwise it will show
diagnostic messages like these:

    t/03podcoverage.t .. 2/? # YourProject::Controller::Root: naked 4 subroutine(s)
    # YourProject::Controller::NotRoot: naked 8 subroutine(s)
    # YorProject::Controller::AlsoNotRoot: naked 3 subroutine(s)
    ...

This module will help you to cover your project step-by-step. And your new code will be covered by POD.

Interface is like the Test::Pod::Coverage manpage:

    use Test::Pod::Coverage::Permissive;

    use Test::More;
    eval "use Test::Pod::Coverage::Permissive";
    plan skip_all => "Test::Pod::Coverage::Permissive required for testing POD coverage" if $@;
    all_pod_coverage_ok();


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/T*

%changelog
