%define module_name Test-Pod-CoverageChange
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Dir/Self.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find/Rule.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/Util.pm) perl(Module/Path.pm) perl(Path/Tiny.pm) perl(Pod/Checker.pm) perl(Pod/Coverage.pm) perl(Test/Builder/Tester.pm) perl(Test/CheckDeps.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod/Coverage.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: Test Perl files for POD coverage and syntax changes
Group: Development/Perl
License: perl
URL: https://github.com/katew-deriv/perl-Test-Pod-CoverageChange

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DE/DERIV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Test::Pod::CoverageChange' is a helper combining the Test::Pod::Coverage manpage and
the Pod::Checker manpage to test for both POD coverage and syntax changes for a module
distribution at once, via a single call to the pod_coverage_syntax_ok entry elsewhere in this document.

Possible results

=over 4

=item * passes if the file has no POD syntax or coverage error.

=item * fails if latest changes increased/decreased numbers of naked subs for the packages that have allowed naked subs.

=item * fails if a package allowed to have naked subs has 100%% POD coverage.

=item * fails if a file in a given path has POD syntax error or has no POD.

=back

Ignores packages that passed as ignored package in the c<$ignored_package> argument into the pod_coverage_syntax_ok sub.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/T*

%changelog
