Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(HTTP/Tiny.pm) perl(JSON.pm) perl(MIME/Lite.pm) perl(Mail/Sendmail.pm) perl(Net/FTP.pm) perl(URI.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Test-Smoke
Version:        1.78
Release:        alt2_7
Summary:        Perl core test smoke suite
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Test-Smoke
Source0:        https://cpan.metacpan.org/authors/id/A/AB/ABELTJE/Test-Smoke-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(JSON/XS.pm)
BuildRequires:  perl(strict.pm)
# Run-time
BuildRequires:  perl(Archive/Tar.pm)
BuildRequires:  perl(autodie.pm)
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Capture/Tiny.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(CGI/Util.pm)
BuildRequires:  perl(Compress/Zlib.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Getopt/Long.pm)
# HTTP::Tiny is not needed for tests
# LWP::Simple is not needed for tests
BuildRequires:  perl(LWP/UserAgent.pm)
# Mail::Sendmail - optional tests - bundled
# BuildRequires:  perl(MIME::Lite)
# Net::FTP is not needed for tests
BuildRequires:  perl(overload.pm)
# Pod::Usage is not needed for tests
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(System/Info.pm)
BuildRequires:  perl(Text/ParseWords.pm)
BuildRequires:  perl(Time/Local.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
# Tests:
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Errno.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(HTTP/Daemon.pm)
BuildRequires:  perl(HTTP/Headers.pm)
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(HTTP/Status.pm)
BuildRequires:  perl(IO/Zlib.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(subs.pm)
BuildRequires:  perl(Test/Builder.pm)
BuildRequires:  perl(Test/Fatal.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/NoWarnings.pm)
BuildRequires:  perl(version.pm)
Requires:       perl(Mail/Sendmail.pm)
Requires:       perl(File/Spec.pm) >= 0.820


Source44: import.info
%filter_from_provides /perl(Mail.Sendmail.pm)/d

%description
The perl core test smoke suite is a set of scripts and modules that try to run
the perl core tests on as many configurations as possible and combine the
results into an easy to read report.

%prep
%setup -q -n Test-Smoke-%{version}

# Ignore output files from find-debuginfo.sh to fix the test 00-manifest.t
echo '.+\.list' >> MANIFEST.SKIP

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}" NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*
rm -rf %{buildroot}/%{_bindir}/W32Configure.pl
rm -rf %{buildroot}/%{_mandir}/man1/W32Configure*
rm -rf %{buildroot}/%{perl_vendor_privlib}/inc/JSON.pm
rm -rf %{buildroot}/%{perl_vendor_privlib}/inc/Mail/Sendmail.pm

%files
%doc Changes README ReleaseNotes
%{_bindir}/archiverpt.pl
%{_bindir}/chkbcfg.pl
%{_bindir}/configsmoke.pl
%{_bindir}/mailrpt.pl
%{_bindir}/patchtree.pl
%{_bindir}/runsmoke.pl
%{_bindir}/sendrpt.pl
%{_bindir}/smokeperl.pl
%{_bindir}/smokestatus.pl
%{_bindir}/synctree.pl
%{_bindir}/sysinfo.pl
%{_bindir}/tsarchive.pl
%{_bindir}/tsreport.pl
%{_bindir}/tsrunsmoke.pl
%{_bindir}/tssendrpt.pl
%{_bindir}/tssmokeperl.pl
%{_bindir}/tssynctree.pl
%{perl_vendor_privlib}/*
%{_mandir}/man1/*

%changelog
