# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Class/Factory.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Getopt/Awesome.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(TAP/Harness.pm) perl(Test/More.pm) perl(YAML/Syck.pm) perl(YAML/Tiny.pm) perl(base.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.17
%define module_name Test-System
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.17
Release: alt1
Summary: Test suite oriented for testing system administration tasks
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/P/PF/PFISCHER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Loads and runs a set of tests for verifying a system administration task
before a possible incident happens or after a task is executed.

Tests can be run as perl scripts and actually in any format the TAP::Harness manpage
supports.

Some examples of how the Test::System manpage can help you:

=over 4

=item *

Before a deployment probably you want to make sure your systems and
configuration files are ready to go. Also you probably want to make sure
that if you needed to apply patches to your configuration files, they
really got applied (even in a development server or verify directly on
production servers). So here the Test::System manpage can help you verifying this
in the form of a test case. Of course, you write the test case :-)

=item *

What about if you have many servers and although you have nagios to verify
the speed of the CPU sometimes you need to verify it "on-demand" (perhaps when
you get new servers in your datacenter). Here the Test::System manpage can help you to
verify that these servers are ready to go before even they get connected to nagios
or your favorite monitoring tool.

=back

One of the things you need to keep in mind is that the Test::System manpage is NOT a
monitoring system. It will let you verify things on demand, things that are
repetitive and perhaps you want them to be automated.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES README example
%perl_vendor_privlib/T*

%changelog
