%define module_name Text-ASCII-Convert
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.33
Release: alt1
Summary: Perl module to convert non-ASCII characters to their ASCII equivalents
Group: Development/Perl
License: gpl
URL: https://github.com/mxguardian/Text-ASCII-Convert

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FK/FKENTO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module attempts to convert non-ASCII characters in a string to their closet ASCII homoglyph. The input
can be a string of Unicode characters or a string of UTF-8 octets. The output is always a string of ASCII characters
in the range 0x00 to 0x7F.

This is most useful for catching spam that uses non-ASCII characters to obfuscate words. For example,

    a'ou haeve a naUw vaBice-maeil
    You hava. Re.''eaEved an En.''rypta.d Company Maadl

would be converted to

    You have a new voice-mail
    You have ReCeived an EnCrypted Company Mail

Unlike other transliteration software, this plugin converts non-ASCII characters
to their ASCII equivalents based on appearance instead of meaning. For example, the
German eszett character 'a'' is converted to the Roman letter 'B' instead of 'ss'
because it resembles a 'B' in appearance. Likewise, the Greek letter Sigma ('.e') is
converted to 'E' and a lower case Omega ('.'') is converted to 'w' even though these
letters have different lexical meanings.

Not all non-ASCII characters are converted. For example, the Japanese Hiragana
character '.''' is not converted because it does not resemble any ASCII character.
Characters that have no ASCII equivalent are replaced by spaces. To avoid long runs
of spaces, multiple spaces are collapsed into a single space. For example,

    Find .'''.'''Singles.'''.''' in your Area

would be converted to

    Find Singles in your Area

The plugin also removes zero-width characters such as the zero-width
space (U+200B) and zero-width non-joiner (U+200C) that are often used to
obfuscate words.

Control characters such as tabs, newlines, and carriage returns are retained.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md
%perl_vendor_privlib/T*

%changelog
