%define module_name Text-CSV-Pivot
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(Test/More.pm) perl(Text/CSV.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.09
Release: alt1
Summary: Transform CSV file into Pivot Table format.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MANWAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Recently I was asked to prepare pivot table using csv  file  at work. Having done
that using quick and dirty perl script, I decided to clean up and make it generic
so that others can also benefit.

Below is sample data, I used for prototype as source csv file.

    +----------------+-----------+-----------------+
    | Student        | Subject   | Result | Year   |
    +----------------+-----------+--------+--------+
    | Smith, John    | Music     | 7.0    | Year 1 |
    | Smith, John    | Maths     | 4.0    | Year 1 |
    | Smith, John    | History   | 9.0    | Year 1 |
    | Smith, John    | Language  | 7.0    | Year 1 |
    | Smith, John    | Geography | 9.0    | Year 1 |
    | Gabriel, Peter | Music     | 2.0    | Year 1 |
    | Gabriel, Peter | Maths     | 10.0   | Year 1 |
    | Gabriel, Peter | History   | 7.0    | Year 1 |
    | Gabriel, Peter | Language  | 4.0    | Year 1 |
    | Gabriel, Peter | Geography | 10.0   | Year 1 |
    +----------------+-----------+--------+--------+

I aim to get something like this below.

    +----------------+--------+-----------+---------+----------+-------+-------+
    | Student        | Year   | Geography | History | Language | Maths | Music |
    +----------------+--------+-----------+---------+----------+-------+-------+
    | Gabriel, Peter | Year 1 | 10.0      | 7.0     | 4.0      | 10.0  | 2.0   |
    | Smith, John    | Year 1 | 9.0       | 9.0     | 7.0      | 4.0   | 7.0   |
    +----------------+--------+-----------+---------+----------+-------+-------+

With the help of the Text::CSV::Pivot manpage, I came up with the following solution.

    use strict; use warnings;
    use Text::CSV::Pivot;

    Text::CSV::Pivot->new({ input_file    => 'sample.csv',
                            col_key_idx   => 0,
                            col_name_idx  => 1,
                            col_value_idx => 2 })->transform;

After executing the above code, I got the expected result in `sample.pivot.csv'.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/T*

%files scripts
%_bindir/*

%changelog
