# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define module_version 0.100
%define module_name Timer-CPU
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.100
Release: alt7
Summary: Precise user-space timer using the CPU clock
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/F/FR/FRACTAL/%module_name-%module_version.tar.gz

%description
For most timer operations, the Time::HiRes manpage is great. Since it provides microsecond resolution in real "wall-clock" time it is very useful for determining how long an operation actually takes in seconds.

However, on most CPUs it is possible to take much higher resolution measurements. These measurements aren't in absolute units like seconds but instead in "cycles" or "ticks". These measurements relate to wall-clock time via an unspecified conversion ratio and can therefore only be used for relative comparisons between code on the same machine (and are subject to other constraints described below).

The resolution of this module is extremely high. For example, it can detect the difference between a sub that returns nothing, one that returns a number, and one that returns an empty string. It can detect whether an `if' branch is taken or not, and even the difference between `eq' comparing strings that match and strings that differ by only the last character.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/T*
%perl_vendor_autolib/*

%changelog
