%ifndef _build_display
%def_without test
%endif
%define module_version 0.13
%define module_name Tk-ContextHelp
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(Tk.pm) perl(Tk/InputO.pm) perl(Tk/LabFrame.pm) perl(Tk/Pod.pm) perl(Tk/ROText.pm) perl(Tk/Toplevel.pm) xvfb-run
# END SourceDeps(oneline)
%ifndef _build_display
%def_without test
%endif
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: context-sensitive help with perl/Tk
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SR/SREZIC/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
ContextHelp provides a context-sensitive help system. By activating
the help system (either by clicking on a HelpButton or calling the
activate method, the cursor changes to a left pointer with a
question mark and the user may click on any widget in the window to
get a help message or jump to the corresponding pod entry.

ContextHelp accepts all the options that the Label widget
accepts. In addition, the following options are also recognized.

=over 4

=item -callback

Set a callback to be called on each state change (useful for own
HelpButton implementations).

=item -cursor

Use another cursor for the help mode instead of the left pointer with
question mark.

=item -helpkey

Enable use of a help key. A common choice would be "F1" (or written as
"<F1>") or maybe "<Help>", if your keyboard has a help key.

=item -offcursor

Use another cursor for the help mode shown if the underlying widget is
not attached to the help system. The default is a left pointer with a
strike-through question mark.

=item -podfile

Set the pod file for the -pod argument of attach. The default is
`$0' (the current script).

=item -stayactive

If set to true, help mode is active until set to false. So the user
may browse over all topics he like.

=item -verbose

Be verbose if something goes wrong. Default is true.

=item -widget

Use another widget instead of the default Label for displaying
messages. Another possible choice would be Message.

=back


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build
xvfb-run -a make test
xvfb-run -a make test

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/T*

%changelog
