Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: /usr/bin/xvfb-run perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Run X11 tests
%{bcond_with perl_Tk_GraphViz_enables_x11_test}

Name:           perl-Tk-GraphViz
Version:        1.10
Release:        alt1_5
Summary:        Render an interactive GraphViz graph
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Tk-GraphViz
Source0:        https://cpan.metacpan.org/authors/id/E/ET/ETJ/Tk-GraphViz-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  graphviz libgraphviz
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(IO.pm)
BuildRequires:  perl(IPC/Open3.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Text/ParseWords.pm)
BuildRequires:  perl(Tk.pm)
BuildRequires:  perl(Tk/Canvas.pm)
BuildRequires:  perl(Tk/Derived.pm)
BuildRequires:  perl(Tk/Font.pm)
BuildRequires:  perl(Tk/IO.pm)
BuildRequires:  perl(vars.pm)
# Tests
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(GraphViz.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/More.pm)
%if %{with perl_Tk_GraphViz_enables_x11_test}
# X11 tests:
BuildRequires:  xorg-xvfb xvfb-run
BuildRequires:  fontlang(en)
%endif
Requires:       graphviz libgraphviz
Requires:       perl(File/Temp.pm)
Requires:       perl(Pod/Usage.pm)
Requires:       perl(Tk/BrowseEntry.pm)
Requires:       perl(Tk/DialogBox.pm)

Provides:       bundled(perl-Parse-Yapp) = 1.21

# Do not provide private bundled Parse::Yapp::Driver module

Source44: import.info
%filter_from_provides /^perl(Parse.Yapp.Driver.pm)/d

%description
The GraphViz widget is derived from Tk::Canvas. It adds the ability to
render graphs in the canvas. The graphs can be specified either using the
DOT graph-description language, or using via a GraphViz object.

%prep
%setup -q -n Tk-GraphViz-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
%if %{with perl_Tk_GraphViz_enables_x11_test}
    xvfb-run -d make test
%else
    make test
%endif

%files
%doc Changes parseRecordLabel.yp README
%{_bindir}/tkgraphviz
%{perl_vendor_privlib}/*
%{_mandir}/man1/*

%changelog
