Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-User-Utmp
Version:        1.8
Release:        alt12_43
Summary:        Perl access to utmp- and utmpx-style databases
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/User-Utmp
Source0:        https://cpan.metacpan.org/authors/id/M/MP/MPIOTR/User-Utmp-%{version}.tar.gz
# Fix strlen identifier clash, CPAN RT #43016
Patch0:         User-Utmp-1.8-strlen.patch
# Adjust to ExtUtils-MakeMaker-7.48, bug #1886390, CPAN RT#133492
Patch1:         User-Utmp-1.8-Make-hints-scripts-strict-conformant.patch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
# glibc-common for iconv
BuildRequires:  glibc-core glibc-timezones glibc-utils iconv
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(DynaLoader.pm)
BuildRequires:  perl(AutoLoader.pm)
# Tests:
BuildRequires:  perl(POSIX.pm)


Source44: import.info

%description
UNIX systems record information about current and past log-ins in a user
accounting database. This database is realized by two files: File utmpx
contains a record of all users currently logged onto the system, while file
wtmpx contains a record of all log-ins and log-outs. Some systems (such as
HP-UX and AIX) also maintain a third file containing failed log-in attempts.
The information in these files is used by commands such as who(1), last(1),
write(1), or login(1).

%prep
%setup -q -n User-Utmp-%{version}
%patch0  -p0
%patch1  -p1
chmod -x example.pl
sed -i -e '1 s/^#!.*//' -e '1 ause utf8;' example.pl
for F in example.pl README; do
    iconv -f ISO-8859-1 -t UTF-8 < "$F" > "${F}.utf8"
    touch -r "$F" "${F}.utf8"
    mv "${F}.utf8" "${F}"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1 OPTIMIZE="$RPM_OPT_FLAGS"
%{make_build}

%install
%{makeinstall_std}
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc Changes example.pl README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/User*

%changelog
