%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(SOAP/Lite.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name WWW-PIDS
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Perl API for the tramTRACKER PIDS Web Service
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/L/LT/LTP/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
WWW::PIDS is a Perl API to the PIDS tramTRACKER web service.

The tramTRACKER PIDS web service *"is a public Web Service that provides a set 
of Web Methods to request real-time and scheduled tram arrival times, as well 
as stops and routes information."*.

You can find more information on the tramTRACKER PIDS web service here
http://ws.tramtracker.com.au/pidsservice/pids.asmx.

    use WWW::PIDS;

    my $p = WWW::PIDS->new();

    # Get a list of route summaries as WWW::PIDS::RouteSummary objects
    my @routes = $p->GetRouteSummaries();

    # Print all route numbers and descriptions
    for my $route ( @routes ) {
      printf( "%%-3s : %%s\n", $route->RouteNo, $route->Description )
    }

    # Tweaking our recipe above; let's display an in-oder list of the
    # stop names for each route and add pretty up our output.
    for my $route ( @routes ) { 
      printf( "%%s\n| %%-3s | %%-71s|\n%%s\n",
            ('+-----+' . ('-'x72).'+'),     # Ugly ascii "table"
            $route->RouteNo,
            $route->Description,
            ('+-----+' . ('-'x72).'+') );
    
      my @stops = $p->GetListOfStopsByRouteNoAndDirection( 
____routeNo => $route->RouteNo, 
____isUpDirection => 0
__  ); 
    
      for my $stop ( @stops ) { 
        printf( "  |__ %%s\n", $stop->Description )
      }
    }

    # Produces a route stop listing like:
    +------------------------------------------------------------------------------+
    | 1   | East Coburg - South Melbourne Beach                                    |
    +------------------------------------------------------------------------------+
      |__ Beaconsfield Pde
      |__ Little Page St
      |__ Richardson St
      |__ Cardigan St
      |__ Bridport St
      |__ Montague St

    # And then we can add the next three predicted arrival times for each stop with:
    for my $route ( @routes ) { 
      printf( "%%s\n| %%-3s | %%-71s|\n%%s\n",
            ('+-----+' . ('-'x72).'+'),     # Ugly ascii "table"
            $route->RouteNo,
            $route->Description,
            ('+-----+' . ('-'x72).'+') );
    
      my @stops = $p->GetListOfStopsByRouteNoAndDirection( routeNo => $route->RouteNo, isUpDirection => 0); 
    
      for my $stop ( @stops ) { 
        my @times = map { 
                          ( my $t = $_->PredictedArrivalDateTime ) =~ s/(^.*)T(.*)\+10:00/$2 $1/; $t
                    } $p->GetNextPredictedRoutesCollection( stopNo => $stop->TID, routeNo => $route->RouteNo, lowFloor => 0 );
        printf( "  |__ %%-30s (%%4s) - %%s\n", $stop->Description, $stop->TID, ( join " - ", @times ) )
      }
    
      print "\n";
    }

    # Produces something like:
    +-----+------------------------------------------------------------------------+
    | 1   | East Coburg - South Melbourne Beach                                    |
    +-----+------------------------------------------------------------------------+
      |__ Beaconsfield Pde               ( 1242) - 16:16:00 2015-09-14 - 16:25:00 2015-09-14 - 16:33:00 2015-09-14
      |__ Little Page St                 ( 1241) - 16:17:00 2015-09-14 - 16:26:00 2015-09-14 - 16:34:00 2015-09-14
      |__ Richardson St                  ( 1240) - 16:17:00 2015-09-14 - 16:26:00 2015-09-14 - 16:34:00 2015-09-14
      |__ Cardigan St                    ( 1239) - 16:18:00 2015-09-14 - 16:27:00 2015-09-14 - 16:35:00 2015-09-14
      |__ Bridport St                    ( 1238) - 16:19:00 2015-09-14 - 16:28:00 2015-09-14 - 16:36:00 2015-09-14
      |__ Montague St                    ( 1237) - 16:20:00 2015-09-14 - 16:29:00 2015-09-14 - 16:37:00 2015-09-14

    # ... and many other helpful methods inside ;)

This Perl API aims to implement a one-to-one binding with the methods provided
by the web service.  Accordingly, the method names within this package are
named after the corresponding names of the methods exposed via the web service.
Unfortunately, this results in some exceedingly long camel-cased method names -
those wanting more aesthetically named methods and slightly more usable syntax
may prefer the WWW::PIDS::Sugar package.

Please see the the NOTES manpage section regarding the terminology, convention, and
specifities of this module including naming of parameters.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md Changes
%perl_vendor_privlib/W*

%changelog
