# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Response.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Test2/Tools/Exception.pm) perl(Test2/V0.pm) perl(Weather/API/Base.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Weather-OWM
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2
Release: alt1
Summary: Perl client for the OpenWeatherMap (OWM) API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DK/DKECHAG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Weather::OWM manpage is a lightweight Perl client supporting most OpenWeatherMap (OWM) APIs,
including the latest One Call v3.0.

There is an easy-to-use object oriented interface that can return the data in hashes.
There are virtually no dependencies, except the LWP::UserAgent manpage for the requests, and
optionally the JSON manpage or the XML::Simple manpage if you want to decode JSON (most common) or XML data.

Current OWM API support:

=over 4

=item * OneCall API 3.0 for current weather, forecast and weather history.

=item * Weather API 2.5 including free (current weather, 3h/5d forecast) and paid forecasts.

=item * Historical APIs 2.5 (history, statistical, accumulated).

=item * Geocoding API 1.0 for direct/reverse geocoding.

=back

Please see the official OWM website for extensive
documentation. Note that even the free APIs require registering
for an API key.

This module belongs to a family of weather modules (along with the Weather::Astro7Timer manpage
and the Weather::WeatherKit manpage) created to serve the apps Xasteria
and Polar Scope Align, but if your
service requires some extra functionality, feel free to contact the author about adding it.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/W*

%changelog
