%define module_name WebService-GoShippo
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/CookieJar.pm) perl(HTTP/Request/Common.pm) perl(HTTP/Thin.pm) perl(HTTP/Tiny.pm) perl(JSON.pm) perl(Moo.pm) perl(Ouch.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(URI.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0002
Release: alt1
Summary: A simple client to L<Shippo's REST API|https://goshippo.com/docs/intro/>.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CO/COLINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A light-weight wrapper for Shippo's RESTful API (an example of which can be found at: https://goshippo.com/docs/reference). This wrapper basically hides the request cycle from you so that you can get down to the business of using the API. It doesn't attempt to manage the data structures or objects the web service interfaces with.

The module takes care of all of these things for you:

=over 4

=item Adding authentication headers

`WebService::GoShippo' adds an authentication header of the type "Authorization: `$tj->token'" to each request.

=item Adding api version number to request header.

`WebService::GoShippo' can optionally add a header selecting a particular version of the API ` $tj->version ' to each request you submit.  If you do not request a particular API version,
then Shippo will use the version specified in your account settings.

=item PUT/POST data translated to JSON

When making a request like:

    $tj->post('customers', { customer_id => '27', exemption_type => 'non_exempt', name => 'Andy Dufresne', });

The data in POST request will be translated to JSON using <JSON::to_json> and encoded to UTF8.

=item Response data is deserialized from JSON and returned from each call.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/W*

%changelog
