%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Accessor.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(LWP/UserAgent.pm) perl(SOAP/Lite.pm) perl(Test.pm) perl(URI.pm) perl(URI/QueryParam.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 0.8
%define module_name WebService-Validator-Feed-W3C
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.8
Release: alt1
Summary: Interface to the W3C Feed Validation service
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/O/OL/OLIVIERT/WebService/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is an  interface to the W3C Feed Validation online service 
http://validator.w3.org/feed/, based on its SOAP 1.2 support. 
It helps to find errors in RSS or Atom feeds.

The following methods are available:

=over 4

=item my $val = WebService::Validator::Feed::W3C->new

=item my $val = WebService::Validator::Feed::W3C->new($ua)

=item my $val = WebService::Validator::Feed::W3C->new($ua, $url)

Creates a new WebService::Validator::Feed::W3C object. A custom
the LWP::UserAgent manpage object can be supplied which is then used for HTTP
communication with the W3C Feed Validation service. $url is the URL of the Feed
Validator, `http://validator.w3.org/feed/check.cgi' by default.

=item my $success = $val->validate(%%params)

Validate a feed takes `%%params' as defined below. Either `string'
or `uri' must be supplied. Returns a true value if the validation succeeded
(regardless of whether the feed contains errors).

=over 4

=item string => $feed_string

An atom or RSS feed, as a string. It is currently unlikely that validation will work
if the string is not a legal UTF-8 string. If a string is specified, the `uri'
parameter will be ignored. Note that `GET' will be used to pass the string
to the Validator, it might not work with overly long strings.

=item uri => $feed_uri

The location of an RSS/Atom feed

=back

=item my $success = $val->success

Same as the return value of `validate()'.

=item my $is_valid = $val->is_valid

Returns a true value if the last attempt to `validate()' succeeded and the
validator reported no errors in the feed.

=item my @errors = $val->errors

Returns a list with information about the errors found for the
feed. An error is a hash reference; the example in the
synopsis would currently return something like

  ( {
          type -> 'MissingDescription',
          line => '23',
          column => '0',
          text => 'Missing channel element: description',
          element =>description,
          parent =>channel,
  } )


=item my @warnings = $val->warnings

Returns a list with information about the warnings found for the
feed

@@example

=item my $ua = $val->user_agent

=item my $ua = $val->user_agent($new_ua)

The the LWP::UserAgent manpage object you supplied to the constructor or a
custom object created at construction time you can manipulate.

  # set timeout to 30 seconds
  $val->user_agent->timeout(30);
  
You can also supply a new object to replace the old one.

=item my $uri = $val->validator_uri

=item my $uri = $val->validator_uri($validator_uri)

Gets or sets the URI of the validator. If you did not specify a
custom URI, `http://validator.w3.org/feed/check.cgi' by
default.

=item my $response = $val->response

The the HTTP::Response manpage object returned from the last request. This is
useful to determine why validation might have failed.

  if (!$val->validate(string => $feed_string)) {
    if (!$val->response->is_success) {
      print $val->response->message, "\n"
    }
  }

=item my $uri = $val->request_uri

The the URI manpage object used for the last request.

=item my $som = $val->som

The the SOAP::SOM manpage object for the last successful deserialization, check the
return value of `validate()' or `success()' before using the object.

=back

%prep
%setup -n %module_name-%module_version
find . -name '._*' -print -delete

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/W*

%changelog
