# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Tiny.pm) perl(Hash/Inflator.pm) perl(IO/Socket/SSL.pm) perl(JSON/MaybeXS.pm) perl(Mozilla/CA.pm) perl(Net/SSLeay.pm) perl(Test/RequiresInternet.pm) perl(Time/HiRes.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name WebService-Vichan
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001001
Release: alt1
Summary: API client for 4chan and vichan-based imageboards
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is an api client for 4chan.org and imageboards that use vichan
(such as 8ch.net). It offers the following methods:

Note: functions that ordinarily return lists will return arrayrefs if
called in scalar context.

=over

=item WebService::Vichan->new(*$url*)

Creates a new WebService::Vichan object with the given base URL.

Two constants are exported on request by this module: `API_4CHAN' and
`API_8CHAN', which represent the base URLs for 4chan.org and 8ch.net.

=item $chan->boards

Returns a list of available boards. These are blessed
imageboard-dependent hashrefs which should at least have the methods
`board' (returning the board code as a string) and `title'.

=item $chan->threads(*$board*)

Takes a board object (or a board code as a string) and returns a list
of pages of thread OPs. Each page is a blessed hashref with methods
`page' (the index of the page) and `threads' (an arrayref of thread
OPs on that page). Each thread OP is a blessed hashref which has at
least the methods `no' (the thread number) and `last_modified'.

=item $chan->threads_flat(*$board*)

Same as threads but page information is dropped. Returns a list of
thread OPs as described above.

=item $chan->catalog(*$board*)

Same as threads, but much more information is returned about each
thread OP.

=item $chan->catalog_flat(*$board*)

Same as threads_flat, but much more information is returned about each thread OP.

=item $chan->thread(*$board*, *$threadno*, [*$is_4chan*])

Takes a board object (or a board code as a string), a thread OP object
(or a thread number) and an optional boolean indicating whether to use
4chan logic for the request (by default 4chan logic is used if the URL
contains `4cdn.org').

Returns a post object (blessed hashref) with methods as described in
the API documentation (see links in the SEE ALSO section).

=back

To comply with API usage rules every request is cached for 10 seconds,
and requests are rate-limited to one per second. If a method is called
less than 1 second after a request has happened, it wi...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/W*

%changelog
