# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl(XML/Driver/HTML.pm) perl(XML/Handler/YAWriter.pm) perl(XML/Parser/PerlSAX.pm) perl(XML/XPath.pm) perl(XML/XPath/Builder.pm) perl(XML/XPath/Node.pm) perl(XML/XPath/Node/Element.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name XML-Filter-Digest
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt2
Summary: perl module %module_name
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/K/KR/KRAEHE/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Most XML tools aim to parse some simple XML and to produce some
formatted output. XML::Filter::Digest aims to do the opposite.

Many formats can now be parsed by a SAX Driver. XPath offers a smart
way to write queries to XML. XML::Filter::Digest is a PerlSAX Filter
to query XML and to provide a simpler digest as a result.

XML::Filter::Digest uses its own script language that can be parsed
by XML::Script::Digest to formulate these digest queries.

In fact, a digest script is well-formed XML.

The following script defines that the result XML should have a root
element called *extract*, containing several elements called
*section* starting from the 4th HTML header. Those section
elements contain *id*, *title* and *intro* elements, which in
turn contain the XPath *string-value* of their nodes as character
data.

    <digest name="extract">
    <collect
        name="section"
        node="//html//h2[position()&gt;3]"
        >
        <collect
            name="id"
        node="child::a/attribute::name"
        />
        <collect
            name="title"
        node="."
        />
        <collect
            name="intro"
        node="following-sibling::p[position()=1]"
        />
    </collect>
    </digest>

The digest script parser silently ignores anything other than
*digest* elements and *collect* elements. The *digest*
element needs a *name* attribute defining the name of the root
element, while the *collect* element needs an additional
*node* attribute defining XPath queries for nested elements.

Only a single digest element should exist within a script document,
but there is no need that the digest script be the root element of
the document. Nested within the digest element should be collect
elements. They may contain several other collect elements recursivly.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/X*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
