# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(bitflag.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name bitflag-ct
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: = bitflag + grouping
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SC/SCHOEJO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Have a look at pragma 'bitflag' before reading this.
If just one group of names for different bitflag are considered in an application
then module 'bitflag' is the slim solution.
Only if different groups of bitflag need either distinct namespaces or individual options
this class is the right solution.

When necessity arise to upgrade from using 'bitflag' to 'bitflag::ct' this can easily be done:
If a second group will be required in the same package, handles must be introduced, one for each group.
This handle can be referred to either by a variable or a constant.
Code-snippets before upgrade look like

    package A;
    use bitflag qw(V1 V2 ...);         (1)     define in package A

    package C;
    A:getmask qw(...);                  (2)     call from package C

upgrading replaces above code lines (1),(2) by

    use bitflag::ct {handle=>\$vhandle} qw(V1 V2 ...); (1)
    $vhandle->getmask qw(...);                          (2)

or by

    use bitflag::ct {handle=>'hc'} qw(V1 V2 ...);      (1)
    hc->getmask qw(...);                                (2)

If the second group is located in another package, say `B', the clause
`use bitflag::ct' can be applied without `'handle'' in which case the package
names `A, B' shall replace the handle object in front of its method `getmask'.
Doing so, a default handle is automatically created for the surrounding package.
When expression `A->gethandle(...)' gets evaluated by the interpreter,
the token `A' first will be substituted by the default handle provided in
package `A'.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/b*

%changelog
