Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-criticism
Version:        1.02
Release:        alt2_41
Summary:        Perl pragma to enforce coding standards and best-practices
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/criticism
Source0:        https://cpan.metacpan.org/authors/id/T/TH/THALJEF/criticism/criticism-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time:
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(Perl/Critic.pm)
BuildRequires:  perl(Perl/Critic/Violation.pm)
# Tests:
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(FindBin.pm)
BuildRequires:  perl(IO/String.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Perl/Critic.pm) >= 1.089
Requires:       perl(Perl/Critic/Violation.pm)
Source44: import.info

%description
This pragma enforces coding standards and promotes best-practices by
running your file through Perl::Critic before every execution. In a
production system, this usually isn't feasible because it adds a lot of
overhead at start-up. If you have a separate development environment, you
can effectively bypass the criticism pragma by not installing Perl::Critic
in the production environment. If Perl::Critic can't be loaded, then
criticism just fails silently.

%prep
%setup -q -n criticism-%{version}
chmod 644 lib/*.pm

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
