# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name fp
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: a library for programming in a functional style
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/ST/STEVAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is an experiment in functional programming in perl. It uses nothing but a combination of; subroutines, the `@_' array and a few built in operators to implement a style of functional programming.

None of the code above is all that interesting until you consider that at no point was variable assignment (`='), `if' statements, or non-recursive iteration used. Although, do be entirely honest, there is actually two times when the `=' operator is used in the entire module. The first time is to assign the module's version, the second time is within the import routine, but those are really not parts of this library and really more infastructure anyway. 

Variable assignment is not utilized, instead the contents of the `@_' argument array are accessed/manipulated and passed along as the return of values from functions. Recursion is the only means of iteration, we do not use any of perl's built in iteration mechanisms (`for', `foreach', `while', etc.). All functions are non-destructive to their inputs, and just about everything returns an array of some sort, so function call chaining works quite well. It operates only on flat lists only, since perl will flatten any arrays given as arguments. 

This code is also written without side-effects. Meaning that each function is written to express an algorithm that produces its result rather than produce its result through the coercion of side-effects. Here is an example of what i mean, using even/odd predicate functions.

with side effects:

  sub is_even { (($_[0] %% 2) == 0); }
  sub is_odd { (($_[0] %% 2) != 0); }

without side efffects:

  sub is_even { ($_[0] <= 0) ? true : is_odd($_[0] - 1); }_
  sub is_odd { ($_[0] <= 0) ? false : is_even($_[0] - 1); }

The side-effect version uses the side effects of the mathematical calculation of (x %% 2) to test if x is even or odd. Where the side-effect free version uses mutual recursion to continually subtract 1 from x until it reaches 0, at which point it will be either odd or even based upon the function it stops in.


%prep
%setup -n %module_name-%module_version
find . -name '._*' -print -delete
%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/f*

%changelog
