# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Hash/Ordered.pm) perl(Scalar/Util.pm) perl(Test/Pod.pm) perl(Tie/Array.pm)
# END SourceDeps(oneline)
%define module_name immutable
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0.4
Release: alt1
Summary: Immutable Data Structures for Perl
Group: Development/Perl
License: perl
URL: https://github.com/ingydotnet/immutable-pm

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IN/INGY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `immutable' module provides immutable versions of native Perl data structures.

Immutable data makes programs easier to reason about, and is foundational for functional programming and concurrency.

Immutable objects support both a tied interface (for use with Perl object access syntax) and an OO interface.

Mutating operation like `$h-'{x} = 1> and `delete $h-'{x}> will throw errors. You need to use the OO methods like `$h-'set(x => 1)> and `$h-'del('x')> which will return a new `immutable::map' immutable hash object. By throwing errors on these operations, it will make things obvious when you pass them to existing code that tries to do a mutating operation.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes CONTRIBUTING
%perl_vendor_privlib/i*

%changelog
