Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(LW2.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define real_name libwhisker2
Name:           perl-%{real_name}
Version:        2.5
Release:        alt2_43
Summary:        Perl module geared specifically for HTTP testing
# Automatically converted from old format: BSD - review is highly recommended.
License:        LicenseRef-Callaway-BSD
URL:            http://www.wiretrip.net/rfp/lw.asp
Source0:        http://downloads.sourceforge.net/whisker/%{real_name}-%{version}.tar.gz
#install to vendorlib, not sitelib
Patch0:         %{real_name}-2.4-vendorlib.patch
#include libwhisker1 compatibility bridge
Patch1:         %{real_name}-2.4-lw1bridge.patch
# Perl 5.18 compatibility
Patch2:         %{real_name}-2.5-Editing-iterated-hash-is-undefined.patch
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Pod/Man.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Socket.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(MIME/Base64.pm)
# strict not used at tests
# vars not used at tests
# Tests:
BuildRequires:  perl(Digest/MD5.pm)
BuildRequires:  perl(IO/Select.pm)
BuildRequires:  perl(IO/Socket.pm)
BuildRequires:  perl(Net/SSLeay.pm)
BuildRequires:  perl(Test/Simple.pm)
# All SSL and network related packages are optional at run time.
Requires:     perl(MIME/Base64.pm)
Obsoletes:      perl-libwhisker <= 1.8
Provides:       perl-libwhisker = %{version}-%{release}
Source44: import.info

%description
Libwhisker is a Perl library useful for HTTP testing scripts.  It
contains a pure-Perl implementation of functionality found in the LWP,
URI, Digest::MD5, Digest::MD4, Data::Dumper, Authen::NTLM, HTML::Parser,
HTML::FormParser, CGI::Upload, MIME::Base64, and GetOpt::Std modules.
Libwhisker is designed to be portable (a single perl file), fast (general
benchmarks show libwhisker is faster than LWP), and flexible (great care
was taken to ensure the library does exactly what you want to do, even
if it means breaking the protocol).

%package doc
Group: Documentation
Summary:        Development documentation for %{name}
Requires:       %{name} = %{version}-%{release}
BuildArch:      noarch

%description doc
This package provides examples how to use LW(2) Perl module.


%prep
%setup -qn %{real_name}-%{version}
%patch0  -p1
%patch1  -p1
%patch2  -p1
mv compat/{lw,LW}.pm
# Fix EOLs
for F in CHANGES KNOWNBUGS LICENSE README docs/* scripts/*; do
    sed -e 's/\r$//' "$F" > "${F}.new"
    touch -r "$F"{,.new}
    mv "$F"{.new,}
done
# Fix interpreter path
for F in scripts/*.pl; do
    sed -e '1 s|^#!perl|#!/usr/bin/perl|' "$F" > "${F}.new"
    chmod a+x "${F}.new"
    touch -r "$F"{,.new}
    mv "$F"{.new,}
done

%build
%{make_build}

%install
# Create directories, not created by Makefile.pl
mkdir -p $RPM_BUILD_ROOT%{perl_vendor_privlib}
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man3

%{makeinstall_std}

# Install documentation
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}
cp -a docs scripts $RPM_BUILD_ROOT%{_datadir}/%{name}

#fix permissions
chmod 0644 $RPM_BUILD_ROOT/%{perl_vendor_privlib}/*

%check
cd t 
perl ./test.pl

%files
%doc --no-dereference LICENSE
%doc CHANGES KNOWNBUGS README
%{perl_vendor_privlib}/*

%files doc
%{_datadir}/%{name}

%changelog
