Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
Name:           permlib
Version:        0.2.8
Release:        alt1_15
Summary:        Library for permutation computations

License:        BSD
URL:            https://github.com/tremlin/PermLib
Source0:        https://github.com/tremlin/PermLib/archive/v%{version}.tar.gz
# Doxygen config file written by Jerry James <loganjerry@gmail.com>
Source1:        %{name}-Doxyfile
# Remove -mt suffix from boost_unit_testing_framework DSO
Patch0:         %{name}-0.2.8-boost_mt.patch
# Fix gcc 6 build failure
Patch1:         %{name}-0.2.8-gcc6.patch
BuildArch:      noarch

BuildRequires: boost-devel boost-devel-headers boost-filesystem-devel boost-wave-devel boost-graph-parallel-devel boost-math-devel boost-mpi-devel boost-program_options-devel boost-signals-devel boost-intrusive-devel boost-asio-devel
BuildRequires: ctest cmake
BuildRequires:  dvipng
BuildRequires:  doxygen
BuildRequires: ghostscript-utils ghostscript
BuildRequires: libgmp-devel libgmp_cxx-devel
BuildRequires: /usr/bin/latex texlive-latex-recommended
Source44: import.info

%description
PermLib is a callable C++ library for permutation computations.
Currently it supports set stabilizer and in-orbit computations, based on
bases and strong generating sets (BSGS).  Additionally, it computes
automorphisms of symmetric matrices and finds the lexicographically
smallest set in an orbit of sets.

%package devel
Group: Other
Summary:        Header files for developing programs that use PermLib
Requires: boost-devel-headers
Provides:       bundled(jquery)

%description devel
PermLib is a callable C++ library for permutation computations.
Currently it supports set stabilizer and in-orbit computations, based on
bases and strong generating sets (BSGS).  Additionally, it computes
automorphisms of symmetric matrices and finds the lexicographically
smallest set in an orbit of sets.

This package contains header files for developing programs that use
PermLib.

%prep
%setup -q -n PermLib-%{version}
%patch0 -p1
%patch1
sed "s/@VERSION@/%{version}/" %{SOURCE1} > Doxyfile

%build
%{fedora_cmake} .
make %{?_smp_mflags}

# Build the documentation
mkdir doc
doxygen
rm -f doc/html/installdox

%install
# No install target is generated in the makefile, and
# DESTDIR=$RPM_BUILD_ROOT cmake -P cmake_install.cmake
# does nothing, so we do it by hand.

# Install the header files
mkdir -p $RPM_BUILD_ROOT%{_includedir}
cp -a include/%{name} $RPM_BUILD_ROOT%{_includedir}

%check
ctest

%files devel
%doc AUTHORS CHANGELOG doc/html
%doc LICENSE
%{_includedir}/permlib

%changelog
