Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/glib-gettextize
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           pidgin-privacy-please
Version:        0.7.1
Release:        alt2_24
Summary:        Security and Privacy plugin for Pidgin
Summary(fr):    Plugin de sécurité et confidentialité pour Pidgin

License:        GPLv3
URL:            http://code.google.com/p/pidgin-privacy-please/
Source0:        http://pidgin-privacy-please.googlecode.com/files/%{name}-%{version}.tar.gz
%if 0%{?rhel} <= 5
ExcludeArch:    ppc
%endif
BuildRequires:  gcc
BuildRequires:  gettext gettext-tools
BuildRequires:  intltool
BuildRequires:  pidgin-devel >= 2.5
Requires:       pidgin >= 2.5
Source44: import.info


%description
pidgin-privacy-please is a Pidgin plugin to stop spammers from annoying you.
It offers the following features:
  - Block individual users
  - Auto-reply to blocked messages
  - Block messages from people who are not on your contact list (with an
optional auto-reply)
  - Block messages using regular expressions, either against the message
sender, the message content, or both
  - Suppress repeated/all authorization requests
  - Suppress OSCAR (ICQ/AIM) authorization requests
  - Automatically show user info on authorization requests
  - Block jabber headline messages (eg. alerts from the MSN transport)
  - Block AOL system messages
  - Challenge-response bot-check 
%description -l fr
pidgin-privacy-please est un plugin pour Pidgin qui va empêcher les spammeurs
de vous ennuyer.
Il offre les fonctionnalités suivantes :
  - Blocage d'utilisateurs
  - Réponse automatique pour les messages bloqués
  - Bloque les messages des personnes qui ne sont pas dans votre liste de
contacts (avec une réponse automatique en option)
  - Filtre les messages en utilisant des expressions régulières, dans
l'expéditeur du message, son contenu, ou les deux
  - Supprime les demandes d'autorisation répétées
  - Supprime les demandes d'autorisation d'OSCAR (ICQ / AIM)
  - Affiche automatiquement les informations de l'utilisateur qui demandes une
autorisation
  - Bloque les messages titre de jabber (ex: alertes de transport MSN)
  - Bloque les messages système d'AOL
  - Contrôle des bot par la méthode Challenge-réponse


%prep
%setup -q -n %{name}-%{version}%{?prever}


%build
%configure
make %{?_smp_mflags}


%install
make install DESTDIR=%{buildroot} INSTALL="install -p"
%find_lang %{name}

# remove .la file
rm %{buildroot}/%{_libdir}/pidgin/libpidgin_pp.la



%files -f %{name}.lang
%doc AUTHORS ChangeLog COPYING README
%{_libdir}/pidgin/libpidgin_pp.so


%changelog
