Group: System/Servers
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define _hardened_build 1

Summary: TCP port reservation utility
Name: portreserve
Version: 0.0.5
Release: alt2_38
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License: GPL-2.0-or-later
URL: http://cyberelk.net/tim/portreserve/
Source0: http://cyberelk.net/tim/data/portreserve/stable/%{name}-%{version}.tar.bz2
Source1: portreserve.service
Patch1: portreserve-pid-file.patch

# This is actually needed for the %triggerun script but Requires(triggerun)
# is not valid.  We can use %post because this particular %triggerun script
# should fire just after this package is installed.

BuildRequires:  gcc
BuildRequires: xmlto
Obsoletes: portreserve-selinux < 0.0.3-3
Source44: import.info

%description
The portreserve program aims to help services with well-known ports that
lie in the portmap range.  It prevents portmap from a real service's port
by occupying it itself, until the real service tells it to release the
port (generally in the init script).

%prep
%setup -q

# Avoid a race during start-up if there are no configured ports (bug #1034139).
%patch1  -p1 -b .pid-file

%build
%configure --sbindir=/sbin
make

%install
make DESTDIR=%{buildroot} install
mkdir -p %{buildroot}%{_rundir}/portreserve
mkdir -p %{buildroot}%{_unitdir}
install -m644 %{SOURCE1} %{buildroot}%{_unitdir}/portreserve.service
mkdir -p %{buildroot}%{_sysconfdir}/portreserve
mkdir -p %{buildroot}%{_tmpfilesdir}
cat <<EOF > %{buildroot}%{_tmpfilesdir}/portreserve.conf
d %{_rundir}/portreserve 0755 root root 10d
EOF

%post
%post_service %{name}

%preun
%preun_service %{name}

%files
%doc ChangeLog README COPYING NEWS
%dir %{_rundir}/portreserve
%dir %{_sysconfdir}/portreserve
%config %{_tmpfilesdir}/portreserve.conf
%{_unitdir}/portreserve.service
/sbin/*
%{_mandir}/*/*

%changelog
