# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Client for sending messages to a host's logged in users
Name: rwall
Version: 0.17
Release: alt1_48
License: BSD
Url: ftp://ftp.linux.org.uk/pub/linux/Networking/netkit/
Group: System/Servers
Source: ftp://ftp.linux.org.uk/pub/linux/Networking/netkit/netkit-rwall-%{version}.tar.gz
Source1: rwalld.service
Patch1: netkit-rwalld-0.10-banner.patch
Patch2: netkit-rwall-0.17-strip.patch
Patch3: netkit-rwall-0.17-netgroup.patch
Patch4: netkit-rwall-0.17-droppriv.patch
BuildRequires: perl-devel
Source44: import.info

%description
The rwall command sends a message to all of the users logged into a
specified host.  Actually, your machine's rwall client sends the
message to the rwall daemon running on the specified host, and the
rwall daemon relays the message to all of the users logged in to that
host.

Install rwall if you'd like the ability to send messages to users
logged in to a specified host machine.

%package server
Summary: Server for sending messages to a host's logged in users
Group: System/Servers
Requires: rpcbind

%description server
The rwall command sends a message to all of the users logged into
a specified host.  The rwall-server package contains the daemon for
receiving such messages, and is disabled by default on Red Hat Linux
systems (it can be very annoying to keep getting all those messages
when you're trying to play Quake--I mean, trying to get some work done).

Install rwall-server if you'd like the ability to receive messages
from users on remote hosts.

%prep
%setup -q -n netkit-rwall-%{version}
%patch1 -p1 -b .banner
%patch2 -p1 -b .strip
%patch3 -p1 -b .netgroup
%patch4 -p1 -b .droppriv

/usr/bin/perl -pi -e '
    s|^LDFLAGS=|LDFLAGS="-pie -Wl,-z,relro,-z,now"|;
    s,^BINDIR=.*$,BINDIR=%{_bindir},;
    s,^MANDIR=.*$,MANDIR=%{_mandir},;
    s,^SBINDIR=.*$,SBINDIR=%{_sbindir},;
    ' configure

%build
%ifarch s390 s390x
CFLAGS="$RPM_OPT_FLAGS -fPIC" \
%else
CFLAGS="$RPM_OPT_FLAGS -fpic" \
%endif
sh configure --with-c-compiler=gcc
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS" %{?_smp_mflags}

%install
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man{1,8}
mkdir -p ${RPM_BUILD_ROOT}%{_unitdir}/

make INSTALLROOT=${RPM_BUILD_ROOT} install

install -m 755 %{SOURCE1} ${RPM_BUILD_ROOT}%{_unitdir}/

%post server
%post_service rwalld

%preun server
%preun_service rwalld

%files
%{_bindir}/rwall
%{_mandir}/man1/rwall.1*

%files server
%{_sbindir}/rpc.rwalld
%{_mandir}/man8/rpc.rwalld.8*
%{_mandir}/man8/rwalld.8*
%{_unitdir}/*

%changelog
