Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          sailcut
Version:       1.5.1
Release:       alt1_2
Summary:       A sail design and plotting software

License:       GPL-2.0-only
URL:           http://www.sailcut.com/
Source0:       https://github.com/sailcut/%{name}/archive/v%{version}/%{name}-%{version}.tar.gz
Source1:       sailcut.desktop
Source2:       sailcut.xml

BuildRequires: gcc-c++
BuildRequires: qt5-base-devel qt6-base-devel
BuildRequires: qt6-svg-devel
BuildRequires: qt5-tools qt6-tools qt6-tools-devel
BuildRequires: libxslt xsltproc
BuildRequires: docbook-style-xsl
BuildRequires: transfig
BuildRequires: desktop-file-utils
BuildRequires: shared-mime-info
Source44: import.info


%description
Sailcut CAD is a sail design and plotting software.
It allows you to design and visualize your own sail and compute the accurate
development of all panels in flat sheets.


%prep
%setup -q



%build
%qmake_qt6 PREFIX=%{_prefix} %{name}.pro
%make_build
pushd doc
mkdir build
./makedocs $PWD/build
popd


%install
make INSTALL_ROOT=%{buildroot} install
install -p -D -m 644 %{SOURCE1} %{buildroot}%{_datadir}/applications/%{name}.desktop
install -p -D -m 644 %{SOURCE2} %{buildroot}%{_datadir}/mime/packages/%{name}.xml
install -p -D -m 644 icons/%{name}.svg %{buildroot}%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
install -p -D -m 644 icons/%{name}-file.svg %{buildroot}%{_datadir}/icons/hicolor/scalable/mimetypes/application-x-%{name}.svg
%{_bindir}/desktop-file-validate %{buildroot}/%{_datadir}/applications/%{name}.desktop
%find_lang %{name} --with-qt


%files -f %{name}.lang
%doc AUTHORS ChangeLog README.md doc/build/en/*
%doc --no-dereference LICENSE
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/mime/packages/%{name}.xml
%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
%{_datadir}/icons/hicolor/scalable/%{name}.svg
%{_datadir}/icons/hicolor/scalable/mimetypes/application-x-%{name}.svg
%{_datadir}/metainfo/org.sailcut.cad.metainfo.xml


%changelog
