Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate pkgconfig(cairo) pkgconfig(glib-2.0) pkgconfig(gmodule-2.0) pkgconfig(gobject-2.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
#global git_date 20120830
#global git_hash 3b11cf8

Name:           smartsim
URL:            http://smartsim.org.uk/
Version:        1.4
Release:        alt2_21
License:        GPLv3
Summary:        Digital logic circuit design and simulation package
Source0:        https://github.com/ashleynewson/SmartSim/archive/v1.4.tar.gz
#Source0:        https://github.com/ashleynewson/SmartSim/tarball/%{git_hash}/smartsim-%{git_hash}.tar.gz
BuildRequires:  gcc
BuildRequires:  gtk3-demo libgail3-devel libgtk+3 libgtk+3-devel libgtk+3-gir-devel libxml2-devel librsvg-devel librsvg-gir-devel
BuildRequires:  ImageMagick-tools desktop-file-utils
Source44: import.info

%description
SmartSim is a free and open source digital logic circuit design and
simulation package.

SmartSim lets you create complex circuits by allowing you to create
your own custom components and including them in other circuits, as if
they were any other built-in component. These larger circuits can then
also be included in other designs as sub-components. SmartSim also
offers the ability to print out or export your circuit designs to PDF,
PNG, or SVG.

When you have finished designing your circuit, SmartSim offers an
interactive simulation feature, allowing you to control your circuit
and explore inside sub-components whilst the circuit is
running. SmartSim also allows you to produce logic timing diagrams
from your simulation's activity, which can then be exported to PDF,
PNG, and SVG formats.

%prep
%setup -q -n SmartSim-%{version}
#setup -q -n ashleynewson-SmartSim-%{git_hash}
./configure --prefix=%{_prefix} --libdir=%{_libdir}

%build
%make_build CFLAGS="%{optflags}"

# create desktop file
cat <<EOF >smartsim.desktop
[Desktop Entry]
Name=smartsim
GenericName=SmartSim
Exec=smartsim
Icon=smartsim
Terminal=false
Type=Application
Categories=Engineering;
EOF

%install
make install DESTDIR="%{buildroot}"

install -d -m 755 %{buildroot}%{_datadir}/applications
install -p -m 644 %{name}.desktop %{buildroot}%{_datadir}/applications

install -d -m 755 %{buildroot}%{_datadir}/pixmaps
convert %{buildroot}%{_datadir}/%{name}/%{name}.ico  %{buildroot}%{_datadir}/pixmaps/%{name}.png

desktop-file-validate %{buildroot}%{_datadir}/applications/%{name}.desktop

%files
%{_bindir}/%{name}
%{_datadir}/%{name}
%doc COPYING README
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png

%changelog
