# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%add_optflags -fcommon

%global 	commit 72d2a6f1a412298cbeae612c184d5d876f0ddf33
%global 	shortcommit %(c=%{commit}; echo ${c:0:7})

Name: 		sniproxy
Version: 	0.6.0
Release: 	alt1_3
Summary: 	Transparent TLS proxy
Group: 		System/Servers
License: 	BSD
URL: 		https://github.com/dlundquist/sniproxy
Source0: 	https://github.com/dlundquist/sniproxy/archive/%{version}/%{name}-%{version}.tar.gz
Source1: 	sniproxy.conf
Source2: 	sniproxy.service
Source3: 	sniproxy.init
Source4:	sniproxy-tmpfiles.conf
Patch0: 	ports-tests-0.4.0.patch

BuildRequires: autoconf
BuildRequires: automake
BuildRequires: curl
BuildRequires: systemd
# for macro definition:
BuildRequires: pkgconfig(systemd)

BuildRequires: pkgconfig(libev)
BuildRequires: pkgconfig(libpcre)
BuildRequires: perl
BuildRequires: libudns-devel
# for lib-prefix.m4
BuildRequires: gettext-devel
# required for EL
BuildRequires: perl(Time/HiRes.pm)

Requires(pre):    shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
Source44: import.info

%description
SNIproxy proxies incoming HTTP and TLS connections based on the host name 
contained in the initial request. This enables HTTPS name based virtual 
hosting to separate back-end servers without the installing the private
key on the proxy machine.


%prep
%setup -q

%patch0 -p1


%build
touch config.rpath
autoreconf -fvi
CFLAGS="${CFLAGS:-%optflags} -I/usr/include/libev" ; export CFLAGS ;
%configure --disable-dependency-tracking
%make_build

%install
%makeinstall_std
mkdir -p %{buildroot}%{_sysconfdir}
install -p -m 644 %{SOURCE1} %{buildroot}%{_sysconfdir}
mkdir -p %{buildroot}%{_unitdir}
install -p -m 644 %{SOURCE2} %{buildroot}%{_unitdir}
mkdir -p %{buildroot}%{_tmpfilesdir}
install -p -m 644 %{SOURCE4} %{buildroot}%{_tmpfilesdir}/%{name}.conf


%pre
getent group sniproxy &>/dev/null || groupadd -r sniproxy
getent passwd sniproxy &>/dev/null || \
    /usr/sbin/useradd -r -g sniproxy -s /sbin/nologin -c sniproxy \
    -d / sniproxy

%post
%_tmpfilescreate %{name}
%post_service sniproxy

%preun
%preun_service sniproxy

%postun
true

%files

%config(noreplace) %{_sysconfdir}/sniproxy.conf

%{_sbindir}/sniproxy
%doc COPYING README.md AUTHORS debian/changelog
%{_unitdir}/sniproxy.service
%{_mandir}/man5/sniproxy.conf.5*
%{_mandir}/man8/sniproxy.8*
%{_tmpfilesdir}/%{name}.conf

%changelog
