# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
# END SourceDeps(oneline)
%define fedora 27
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%if ! (0%{?fedora} || 0%{?rhel} > 5)
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif

%if 0%{?fedora}
%{!?pylint_check: %global pylint_check 1}
%endif

Name:        spacecmd
Version:     2.7.15
Release:     alt1_2
Summary:     Command-line interface to Spacewalk and Red Hat Satellite servers

Group:       System/Base
License:     GPLv3+
URL:         https://github.com/spacewalkproject/spacewalk/wiki/spacecmd
Source:      https://github.com/spacewalkproject/spacewalk/archive/%{name}-%{version}.tar.gz
BuildArch:   noarch

%if 0%{?pylint_check}
BuildRequires: spacewalk-pylint
%endif
BuildRequires: python
BuildRequires: python-devel
BuildRequires: python-module-simplejson
BuildRequires: rpm-python
%if 0%{?rhel} == 5
BuildRequires: python-json
%endif

%if 0%{?rhel} == 5
Requires:    python-module-simplejson
%endif
Requires:    python
Requires:    file

%if 0%{?suse_version}
BuildRequires: python-xml
Requires:      python-xml
Requires:      python-module-simplejson
%endif
Source44: import.info

%description
spacecmd is a command-line interface to Spacewalk and Red Hat Satellite servers

%prep
%setup -q

%build
# nothing to build

%install

mkdir -p %{buildroot}/%{_bindir}
install -p -m0755 src/bin/spacecmd %{buildroot}/%{_bindir}/

mkdir -p %{buildroot}/%{_sysconfdir}
touch %{buildroot}/%{_sysconfdir}/spacecmd.conf

mkdir -p %{buildroot}/%{_sysconfdir}/bash_completion.d
install -p -m0644 src/misc/spacecmd-bash-completion %{buildroot}/%{_sysconfdir}/bash_completion.d/spacecmd

mkdir -p %{buildroot}/%{python_sitelibdir_noarch}/spacecmd
install -p -m0644 src/lib/*.py %{buildroot}/%{python_sitelibdir_noarch}/spacecmd/

mkdir -p %{buildroot}/%{_mandir}/man1
gzip -c src/doc/spacecmd.1 > %{buildroot}/%{_mandir}/man1/spacecmd.1.gz

touch %{buildroot}/%{python_sitelibdir_noarch}/spacecmd/__init__.py
chmod 0644 %{buildroot}/%{python_sitelibdir_noarch}/spacecmd/__init__.py

# touching all ghosts; hack for rpm 4.0.4
for rpm404_ghost in %{_sysconfdir}/spacecmd.conf
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%check
%if 0%{?pylint_check}
PYTHONPATH=$RPM_BUILD_ROOT%{python_sitelibdir_noarch} \
	spacewalk-pylint $RPM_BUILD_ROOT%{python_sitelibdir_noarch}/spacecmd
%endif

%files
%{_bindir}/spacecmd
%{python_sitelibdir_noarch}/spacecmd/
%ghost %config %{_sysconfdir}/spacecmd.conf
%dir %{_sysconfdir}/bash_completion.d
%{_sysconfdir}/bash_completion.d/spacecmd
%doc src/doc/README src/doc/COPYING
%doc %{_mandir}/man1/spacecmd.1*

%changelog
