# BEGIN SourceDeps(oneline):
BuildRequires: pkgconfig(gee-1.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	System and Service Manager UI for systemd
Name:		systemd-ui
Version:	3
Release:	alt1_7
License:	GPLv2+
Group:		System/Configuration/Other
URL:		https://www.freedesktop.org/wiki/Software/systemd
Source0:	https://www.freedesktop.org/software/systemd/systemd-ui-%{version}.tar.xz
Patch0:		systemd-ui-3-Notification.patch
BuildRequires:	autoconf 
BuildRequires:  automake 
BuildRequires:  m4 
BuildRequires:  libtool
BuildRequires:	pkgconfig(dbus-1) >= 1.3.2
BuildRequires:	pkgconfig(gee-0.8)
BuildRequires:	pkgconfig(gio-unix-2.0)
BuildRequires:	pkgconfig(glib-2.0) > 2.26
BuildRequires:	pkgconfig(gtk+-3.0)
BuildRequires:	pkgconfig(libnotify)
BuildRequires:	vala >= 0.11
BuildRequires:	xsltproc

Requires:       polkit
Requires:       systemd

Obsoletes:      systemd-gtk < 45
Provides:       systemd-gtk = %version-%release
Provides:       systemadm = %version-%release
Source44: import.info

%description
Graphical front-end for systemd

It contains : 
	* systemadm is a graphical frontend for the systemd system and service manager
          and allows introspection and control of systemd

%files
%{_bindir}/systemadm
%{_bindir}/systemd-gnome-ask-password-agent
%{_mandir}/man1/systemadm.*
%{_datadir}/applications/systemadm.desktop

#--------------------------------------------------------------------

%prep
%setup -q -n systemd-ui-%{version}
%patch0 -p1


%build
%configure
%make_build

%install
%makeinstall_std

install -d %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/systemadm.desktop <<EOF
[Desktop Entry]
Name=Graphical front-end for systemd
Comment=Modify systemd configuration
Exec=systemadm
Terminal=false
Type=Application
Icon=development_tools_section
Categories=GTK;Settings;System;X-Mageia-CrossDesktop;
EOF


%changelog
