Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global docs_hash 20131007a

Name:		tcl-pgtcl
Version:	2.1.1
Release:	alt2_22
Summary:	A Tcl client library for PostgreSQL

URL:		http://sourceforge.net/projects/pgtclng/
# The PostgreSQL license is very similar to other MIT licenses, but the OSI
# recognizes it as an independent license, so we do as well.
License: PostgreSQL

Source0:	http://downloads.sourceforge.net/pgtclng/pgtcl%{version}.tar.gz
# Note that for some reason docs are date-labeled not version-labeled
Source1:	http://downloads.sourceforge.net/pgtclng/pgtcldocs-%{docs_hash}.zip

Patch1:		pgtcl-no-rpath.patch

Provides:	pgtcl = %{version}-%{release}
# pgtcl was originally shipped as a sub-RPM of the PostgreSQL package;
# these Provides/Obsoletes give a migration path.  Note there is no
# intention of changing the version numbers in future.
Provides:	postgresql-tcl = 8.5.0-1
Obsoletes:	postgresql-tcl < 8.5

BuildRequires:  gcc
BuildRequires:	libpq-devel tcl-devel
BuildRequires:	autoconf


%{!?tcl_version: %global tcl_version %(echo 'puts $tcl_version' | tclsh)}
%{!?tcl_sitearch: %global tcl_sitearch %{_libdir}/tcl%{tcl_version}}
Source44: import.info


%description
PostgreSQL is an advanced Object-Relational database management system.
The tcl-pgtcl package contains Pgtcl, a Tcl client library for connecting
to a PostgreSQL server.


%prep
%setup -q -n pgtcl%{version}

unzip %{SOURCE1}
PGTCLDOCDIR=`basename %{SOURCE1} .zip`
mv $PGTCLDOCDIR Pgtcl-docs

%patch1  -p1

autoconf


%build
%configure --libdir=%{tcl_sitearch} --with-tcl=%{_libdir}
make all %{?_smp_mflags}


%install
make install DESTDIR=$RPM_BUILD_ROOT
# we don't really need to ship the .h file
rm -f $RPM_BUILD_ROOT%{_includedir}/libpgtcl.h


%files
%{_libdir}/tcl%{tcl_version}/pgtcl%{version}/
%doc Pgtcl-docs/*


%changelog
