# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name unac
%define major 1
%define libname lib%{name}%{major}
%define develname lib%{name}-devel

Summary: A command that removes accents
Name: unac
Version: 1.8.0
Release: alt1_12
License: GPLv2+
Group: Text tools
Source: https://ftp.debian.org/debian/pool/main/u/unac/unac_%version.orig.tar.gz
Patch1: unac-1.8.0-automake-1.13.patch
Patch2: unac-fix-building-with-gcc14.patch
URL: https://www.nongnu.org/unac/
BuildRequires: gettext-tools libasprintf-devel
Source44: import.info

%description
unac is a C library and command that remove accents from a string.
For instance the string A.tA. will become ete.  It provides a command
line interface that removes accents from a string given in argument
(unaccent command). In the library function and the command, the
charset of the input string is specified as an argument. The input
string is converted to UTF-16 using iconv(3), accents are stripped and
the result is converted back to the original charset. The iconv --list
command on GNU/Linux will show all charset supported.

%package -n %libname
Group:System/Libraries
Summary: A C library that removes accents

%description -n %libname
unac is a C library and command that remove accents from a string.
For instance the string A.tA. will become ete.  It provides a command
line interface that removes accents from a string given in argument
(unaccent command). In the library function and the command, the
charset of the input string is specified as an argument. The input
string is converted to UTF-16 using iconv(3), accents are stripped and
the result is converted back to the original charset. The iconv --list
command on GNU/Linux will show all charset supported.

%package -n %develname
Group: Development/C
Summary: A C library that removes accents
Requires: %libname = %version-%release
Provides: %name-devel = %version-%release

%description -n %develname
unac is a C library and command that remove accents from a string.
For instance the string A.tA. will become ete.  It provides a command
line interface that removes accents from a string given in argument
(unaccent command). In the library function and the command, the
charset of the input string is specified as an argument. The input
string is converted to UTF-16 using iconv(3), accents are stripped and
the result is converted back to the original charset. The iconv --list
command on GNU/Linux will show all charset supported.

%prep
%setup -q -n %name-%version.orig
%patch1  -p1 -b .automake-1_13
%patch2  -p1 -b .gcc14
touch config.rpath

%build
autoreconf -fi
%configure --disable-static
%make_build

%install
%makeinstall_std
rm -f %{buildroot}%{_libdir}/*.la

%files
%doc ChangeLog README
%{_bindir}/unaccent
%_mandir/man1/unaccent.1*

%files -n %libname
%_libdir/libunac.so.%{major}*

%files -n %develname
%_libdir/libunac*so
%_libdir/pkgconfig/unac.pc
%{_includedir}/unac.h
%{_mandir}/man3/unac.3*


%changelog
