# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global sum     Utility for localized exposure correction

Name:           urbanlightscape
Version:        1.4.0
Release:        alt2_18
Summary:        %{sum}
Group:          Graphics
License:        GPLv2+
Url:            https://www.indii.org/software/urbanlightscape
Source0:        https://www.indii.org/files/urbanlightscape/releases/%{name}-%{version}.tar.gz
Source1:        https://www.indii.org/images/%{name}_128.png
Patch1:         urbanlightscape-wxBitmapBundle.patch
ExclusiveArch:  %{ix86} x86_64
# bc is used to detect wxgtk
BuildRequires:  bc
BuildRequires:  boost-complete
BuildRequires:  ImageMagick-tools
BuildRequires:  libgomp-devel
BuildRequires:  libwxBase3.2-devel libwxGTK3.2-devel
Source44: import.info

%description
Use Urban Lightscape for exposure correction, localized brightness
adjustments and the introduction of artificial lighting to a photo.
By placing control points on the photo, you are able to lighten or
darken (dodge or burn) at these points, with Urban Lightscape
cleverly interpolating between these points to infill adjustments
across the entire photo.

%prep
%setup -q
%patch1 -p1


%build
# The added CXXFLAGS are suggested in the README file
%ifarch x86_64
%define upstream_flags -msse2 -O3 -g3
%else
%define upstream_flags -msse -O3 -g3
%endif
%configure CXXFLAGS="${CXXFLAGS} %{upstream_flags}"
%make_build

%install
%makeinstall_std

# Icon
install -Dm 644 %{SOURCE1} %{buildroot}%{_iconsdir}/hicolor/128x128/apps/%{name}.png

# Menu entry
install -d %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Type=Application
Terminal=false
Name=Urban Lightscape
Comment=%{sum}
Exec=%{name}
Icon=%{name}
Categories=Graphics;Photography;
EOF

%files
%doc COPYING README
%{_bindir}/%{name}
%{_datadir}/%{name}/%{name}.htb
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/128x128/apps/%{name}.png


%changelog
