Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# hardened build if not overriden
%{!?_hardened_build:%global _hardened_build 1}

%if %{?_hardened_build}%{!?_hardened_build:0}
%global cflags_harden -fpie
%global ldflags_harden -pie -z relro -z now
%endif

Summary: Alternative packet radio system for Linux
Name: uronode
Version: 2.15
Release: alt1_11
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License: GPL-2.0-or-later
URL: http://uronode.sourceforge.net
BuildRequires: gcc
BuildRequires: zlib-devel
BuildRequires: libax25-devel
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
Source0: http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Source1: flexd.service
Source2: uronode@.service
Source3: uronode.socket
Source4: uronode.xinetd
Source5: uronode-README.fedora
# Sent upstream
Patch0: uronode-2.7-install-fix.patch
# Sent upstream
Patch1: uronode-2.7-configure-non-interactive.patch
# Sent upstream
Patch2: uronode-2.15-gcc-15-fix.patch
Source44: import.info

%description
URONode is an alternative packet radio system for Linux. It supports
cross-port digipeating, automatic importing of flexnet routing,
various IP functions, and ANSI colors.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1


# Copy Fedora readme into place
cp -p %{SOURCE5} README.fedora

# Removing bundled libax25, using system one.
rm -rf include

%build
export NON_INTERACTIVE=1
export ETC_DIR=%{_sysconfdir}/ax25
export SBIN_DIR=%{_sbindir}
export BIN_DIR=%{_bindir}
export LIB_DIR=%{_prefix}/lib
export DATA_DIR=%{_datadir}
export MAN_DIR=%{_mandir}
export VAR_DIR=%{_var}
./configure
%make_build CFLAGS="%{optflags} %{?cflags_harden}" LDFLAGS="%{?__global_ldflags} %{?ldflags_harden}"

%install
make %{?_smp_mflags} DESTDIR=%{buildroot} install

# Systemd
install -Dpm 644 %{SOURCE1} %{buildroot}%{_unitdir}/flexd.service
install -Dpm 644 %{SOURCE2} %{buildroot}%{_unitdir}/uronode@.service
install -Dpm 644 %{SOURCE3} %{buildroot}%{_unitdir}/uronode.socket

# xinetd
install -Dpm 644 %{SOURCE4} %{buildroot}%{_datadir}/%{name}/xinetd.d/uronode

# ghost files
touch %{buildroot}/%{_var}/lib/flexd/destinations
# assert for case upstream would add default content
[ -s %{buildroot}%{_var}/lib/flexd/gateways ] && exit 1
[ -s %{buildroot}%{_var}/log/uronode/lastlog ] && exit 1
[ -s %{buildroot}%{_var}/lib/uronode/loggedin ] && exit 1
for rpm404_ghost in %{_var}/lib/uronode/loggedin %{_var}/lib/flexd/gateways %{_var}/log/uronode/lastlog %{_var}/lib/flexd/destinations
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done


%post
%post_service flexd

# Create empty database of current users
[ -f %{_var}/lib/uronode/loggedin ] || touch %{_var}/lib/uronode/loggedin

%preun
%preun_service flexd

%files
%doc README.fedora README URONode.his FAQ COLORS CHANGES.1 CHANGES.2 COPYING

%{_sbindir}/*
%{_mandir}/*/*
%config(noreplace) %{_sysconfdir}/ax25/flexd.conf
%config(noreplace) %{_sysconfdir}/ax25/uronode.announce
%config(noreplace) %{_sysconfdir}/ax25/uronode.conf
%config(noreplace) %{_sysconfdir}/ax25/uronode.info
%config(noreplace) %{_sysconfdir}/ax25/uronode.motd
%config(noreplace) %{_sysconfdir}/ax25/uronode.perms
%config(noreplace) %{_sysconfdir}/ax25/uronode.routes
%config(noreplace) %{_sysconfdir}/ax25/uronode.users
%{_datadir}/%{name}/xinetd.d/uronode
%{_unitdir}/flexd.service
%{_unitdir}/uronode@.service
%{_unitdir}/uronode.socket
%{_datadir}/%{name}
%dir %{_var}/log/uronode
%dir %{_var}/lib/flexd
%dir %{_var}/lib/uronode
%ghost %{_var}/lib/uronode/loggedin
%ghost %{_var}/lib/flexd/gateways
%ghost %{_var}/log/uronode/lastlog
%ghost %{_var}/lib/flexd/destinations

%changelog
